// File: textbr.cpp
//
// Description: Free Text Browser Application.
//              This application uses the TextInd Class
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software
//       library may be used in compiled form without
//       restrictions.  All source rights reserved:
//       Source code to the GUI library can not be
//       distributed (on bulletin boards, or as part
//       of shareware or commercial products) without
//       written permission.
//
//       This software is provided "as is". The user
//       accepts all responsibility for its use.
//

#include "applib.h"
#include "textind.h"
#include "char_v.h"

//
//  Global pointer to a text index object:
//

TextIndex *ti = 0;

void TAppWindow::update_display()
{
    // Since we use a scrolling text area for output,
    // we don't have to do anything in 'update_display'.
}

void TAppWindow::idle_proc()
{
    // No background processing is required in 
    // this application
}

void TAppWindow::mouse_down(int x, int y)
{
    // No mouse interaction is required in
    // this application
}

void TAppWindow::mouse_up(int, int)
{
    // No mouse interaction is required in
    // this application
}

void TAppWindow::mouse_move(int x, int y)
{
    // No mouse interaction is required in
    // this application
}

void TAppWindow::do_menu_action(int item_number)
{
    if (item_number == 1) // Load existng index
    {
        char file_name[256];
        if (choose_file_to_read("Load existing index:",
                                "idx",
                                 file_name))
        {
            Warning("Error opening file");
        }  else  {
            ti = new TextIndex(file_name);
        }
    }

    if (item_number == 2) // Create an index form
                          // 1 or more files
    {
        if (ti == (TextIndex *)0) // We need to
                                  // create a new index
        {
            char *fileList[8];
            for (int m=0; m<8; m++)
                fileList[m] = new char[128];
            int get_next_file = 1;
            int count_files = 0;
            while (get_next_file && (count_files < 7)) 
            {
                if (choose_file_to_read(
                           "Next file (blank to stop):",
                           "txt",
                           fileList[count_files]) ||
                    fileList[count_files][0]==' ' ||
                    strlen(fileList[count_files]) < 2) 
                {
                    get_next_file = 0;
                }  else  {
                    count_files++;
                }
            }
            if (count_files > 0)  
            {
                ti = new TextIndex(fileList,count_files);
                ti->print_out();
            }
        }
        else
            Warning("Current index in memory");
    }

    if (item_number == 3) // Save the current index
    {
        char output_file[256];
        if (choose_file_to_write(
                 "Enter output file: (ending with .idx)",
                 output_file))
           Warning("Could not open output file");
         else {
            ti->save(output_file);
        }
    }

    if (item_number == 4) // Word Search
    {
        if (ti != 0) 
        {
            char target_word[256], buf[256];
            target_word[0] = '\0';
            do_edit("Enter the search word:", target_word);
	    char **s = ti->regionTextBlocks(target_word);
            if (s != (char **)0)  
            {
                int count = 0;
                while (s[count] != (char *)0) 
                {
                    count++;
                }
                int user_selection = 
                    choose_one_from_list("Choose..",
                                         s,
                                         count);
                free_strings(s);
                int file, block;
                if (ti->regionIndex(user_selection,
                                    file,
                                    block)) 
                {
                    sprintf(buf,
                            "file=%d, block=%d",
                            file,
                            block);
                    put_scrolling_text(buf);
                    char *buf2 = new char[BLOCK_SIZE + 2];
                    ti->get_text(buf2,
                                 BLOCK_SIZE,
                                 file,
                                 block);
                    int text_len = strlen(buf2);
                    for (int j=0; j<(text_len - 20); j++) 
                    {
                        int eol_flag = 0;
                        for (int l=0; l<255; l++) 
                            buf[l] = '\0';
                        for (int i=j; i<text_len; i++)
                        {
                            if ((i-j) < 254) 
                            {
                                buf[i-j] = buf2[i];
                                if (buf2[i] < 30) 
                                {
                                    buf[i-j] = '\0';
                                    j = i;
                                    eol_flag = 1;
                                    break;
                                }
                            }
                        }
                        if (eol_flag == 0) 
                        {
                            delete [] buf2;
                            return;
                        }
                        if (strlen((char *)buf) < 255) 
                        {
                            put_scrolling_text(buf);
                        }
                    }
                    delete buf2;
                }
            }
        } else
            Warning("No active index");
    }
}


static char *menu_items[] =
    {"Load existing word index",
     "Create new word index from 1 or more files",
     "Save current word index",
     "Word search"};

INIT_PROGRAM("TextBrowser", 4, menu_items)

   // Initialize scrolling text support in our
   // TAppWindow object:

   Application::get_TAppWindow()->
                     init_scrolling_text();
   Application::get_TAppWindow()->
                     put_scrolling_text(
                       "Text Indexer/Browser Application"
                                        );
   
   RUN_PROGRAM;
}
